<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('phone', 'email', 'name', 'blood_type_id', 'password', 'reset_code', 'last_donation_date', 'd_o_b', 'city_id');
    protected $hidden = array('password');

    public function bloodType()
    {
        return $this->belongsTo('App\Models\BloodType');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function posts()
    {
        return $this->morphedByMany('App\Models\Post', 'clintable');
    }

    public function donationRequests()
    {
        return $this->hasMany('App\Models\DonationRequest');
    }

    public function notifications()
    {
        return $this->morphedByMany('App\Models\Notification', 'clintable');
    }

    public function bloodTypes()
    {
        return $this->morphedByMany('App\Models\BloodType', 'clintable');
    }

    public function governorates()
    {
        return $this->morphedByMany('App\Models\Governorate', 'clintable');
    }

    public function tokens()
    {
        return $this->hasMany('App\Models\Token');
    }

}